<?php
// GameCreate.com External Authentication Example
// This is a fully working implementation for external authentication using a phpBB forum database
// Copyright Mammoth Media 2006

// Include the NuSOAP class code
require_once('soap/nusoap.php');

// Create a new SOAP server instance using our ExternalAuthentication schema
$server = new soap_server("ExternalAuthentication.wsdl");

include("includes/webdbfuncs.php");

// Include the database username, password, name and host to use here
$db =& new db('username', 'password', 'databasename', 'databasehost');
$db->connect();

// Search by name callback
function SearchByName($name)
{
	global $db;

	$result = $db->query("SELECT user_id, username, user_email FROM phpbb_users WHERE username LIKE '%s' ORDER BY username ASC", addslashes("%$name%"));

	$users = array();
	while ($row = $db->fetch_array($result))
		$users[] = array("Id"=>$row["user_id"], "Name"=>$row["username"], "Username"=>$row["username"], "Nickname"=>$row["username"], "Email"=>$row["user_email"]);
		
	return array( "SearchByNameResult" => array("ExternalUser" => $users) );
}

// Search by username callback
function SearchByUsername($name)
{
	global $db;

	$result = $db->query("SELECT user_id, username, user_email FROM phpbb_users WHERE username LIKE '%s' ORDER BY username ASC", addslashes("%$name%"));

	$users = array();
	while ($row = $db->fetch_array($result))
		$users[] = array("Id"=>$row["user_id"], "Name"=>$row["username"], "Username"=>$row["username"], "Nickname"=>$row["username"], "Email"=>$row["user_email"] );

	return array( "SearchByUsernameResult" => $users );
}

// Retrieve single user by email callback
function GetByEmail($email)
{
	global $db;
	
	$result = $db->query("SELECT user_id, username, user_email FROM phpbb_users WHERE user_email = %q", $email);
	$row = $db->fetch_array($result);
	
	if (!$row['user_id'])
		return null;

	return array( "GetByEmailResult" => array("Id"=>$row['user_id'], "Name"=>$row['username'], "Nickname"=>$row['username'], "Username"=>$row['username'], "Email"=>$row['user_email']) );
}

// Retrieve single user by unique ID callback
function GetById($id)
{
	global $db;
	
	$result = $db->query("SELECT user_id, username, user_email FROM phpbb_users WHERE user_id = %d", $id);
	$row = $db->fetch_array($result);
	
	if (!$row['user_id'])
		return null;

	return array( "GetByIdResult" => array("Id"=>$row['user_id'], "Name"=>$row['username'], "Nickname"=>$row['username'], "Username"=>$row['username'], "Email"=>$row['user_email']) );
}

// Retrieve single user by unique username / password combination callback
function Login($username, $password)
{
	global $db;
	
	$result = $db->query("SELECT user_id, username, user_email FROM phpbb_users WHERE username = %q AND user_password = md5(%q)", $username, $password);
	$row = $db->fetch_array($result);
	
	if (!$row['user_id'])
		return null;

	return array( "LoginResult" => array("Id"=>$row['user_id'], "Name"=>$row['username'], "Nickname"=>$row['username'], "Username"=>$row['username'], "Email"=>$row['user_email']) );
}

// Use the request to (try to) invoke the service
$data = isset($HTTP_RAW_POST_DATA) ? $HTTP_RAW_POST_DATA : '?';
$server->service($data);


?>