<?php
// GameCreate.com Temporary Server site template wrapper
// www.gamecreate.com

function GC_RenderPage($name)
{
	// Include our stylesheet
	echo '<link rel="stylesheet" type="text/css" href="gamecreate.css">';
	
	// Build a new GameCreate Page object
	$page =& new GCPage();
	
	// Set the domain information. This is in the format of: uniquename.cc
	// cc is the country code of your domain (such as au, us, world, etc)
	// Mammoth Media would use: 'mammoth.au' as their domain url from [http://]mammoth.au[.gamecreate.com]
	$page->SetDomain("uniquename.cc");
	
	// Build an array of the required information each page request will need
	// Consult the GameCreate documentation for more information on what is required here
	// Documentation: http://doc.gamecreate.com/ManualCustomSiteTemplate
	$userinfo = array("__domainlogin__" => "LOGIN",
					"__domainpassword__" => "PASSWORD", 
					"__externalid__" => 0, 
					"__externalname__" => 'GameCreate User');
	
	$page->SetUserInfo($userinfo);
	
	// Request the 'View' page from GameCreate Bookings (View, List, or Edit) pages are available
	$page->Run($name);
}

class GCPage
{
	var $domain;
	var $userinfo;

	function Run($page)
	{
		if ($page == null)
			die("No page was specified to be requested");

		if ($this->domain == null)
			die("Domain information is not set");
		
		if ($this->userinfo == null)
			die("User information is not set");
		
		// Render the requested GameCreate page
		$url = 'http://' . $this->domain . '.gamecreate.com/externalbookings/' . $page . '.aspx';
		
		// Attach query string to end of URL
		$url .= '?' . $_SERVER['QUERY_STRING'];
		
		// Build an associative array of key/value pairs to post
		$postparts = array();
		
		// Include our user information in the array	
		$postdata = array_merge($_POST, $this->userinfo);

		// Attach the form data
		foreach ($postdata as $key => $value)
    		$postparts[] = urlencode($key) . '=' . urlencode($value);

		// Get a post string to use with curl
		$poststring = join("&", $postparts);
		
		// Read the page data using curl
		$handle = curl_init($url);
		curl_setopt($handle, CURLOPT_POST, true);
		curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($handle, CURLOPT_POSTFIELDS, $poststring);
		$result = curl_exec($handle);
		curl_close($handle);
		
		// Retrurned page result, need to replace specific text in order to allow the page links to work correctly
		$search = array('/externalbookings/', 'List.aspx', 'Edit.aspx', 'View.aspx');
		$replace = array('', 'list.php', 'edit.php', 'view.php');

		$result = str_replace($search, $replace, $result);
		
		// Echo the page contents to browser
		echo $result;
	}
	
	function SetUserInfo($info)
	{
		$this->userinfo = $info;
	}
	
	function SetDomain($domain)
	{
		$this->domain = $domain;
	}
	
}

?>